/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.dto.MSyukkinboDto;

public class ApprovalCardVo extends ApprovalListVo {

	private static final long serialVersionUID = -2426894958983879071L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/approvalCard.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/approvalCard.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/approvalCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.NAM_CHECK_APPROVAL;

	// 萔
	public static final int MODE_VIEW			= 0;
	public static final int MODE_APPROVAL		= 1;

	// p[^
	public static final String PRM_HID_K_CODE				= "hidKCode"			;
	public static final String PRM_HID_DATE				= "hidDate"				;

	public static final String PRM_LBL_START_HOUR 		= "lblStartHour"		;
	public static final String PRM_LBL_START_MIN 			= "lblStartMin"			;
	public static final String PRM_LBL_WORK_TYPE 			= "lblWorkType"			;
	public static final String PRM_LBL_START_HALF_HOLIDAY = "lblStartHalfHoliday"	;
	public static final String PRM_LBL_WORK_ON_HOLIDAY 	= "lblWorkOnHoliday"	;

	public static final String PRM_LBL_LATE_HOUR 			= "lblLateHour"			;
	public static final String PRM_LBL_LATE_MIN 			= "lblLateMin"			;
	public static final String PRM_LBL_LATE_REASON 		= "lblLateReason"		;
	public static final String PRM_LBL_LATE_CERTIFICATE 	= "lblLateCertificate"	;
	public static final String PRM_LBL_LATE_COMMENT 		= "lblLateComment"		;

	public static final String PRM_LBL_QUIT_HOUR 			= "lblQuitHour"			;
	public static final String PRM_LBL_QUIT_MIN 			= "lblQuitMin"			;
	public static final String PRM_LBL_QUIT_HALF_HOLIDAY 	= "lblQuitHalfHoliday"	;
	public static final String PRM_LBL_WORK_HOUR 			= "lblWorkHour"			;
	public static final String PRM_LBL_WORK_MIN 			= "lblWorkMin"			;
	public static final String PRM_LBL_BREAK_HOUR 		= "lblBreakHour"		;
	public static final String PRM_LBL_BREAK_MIN 			= "lblBreakMin"			;
	public static final String PRM_LBL_ACTUAL_HOUR		= "lblActualHour"		;
	public static final String PRM_LBL_ACTUAL_MIN			= "lblActualMin"		;

	public static final String PRM_LBL_LEAVE_EARLY_REASON			= "lblLeaveEarlyReason"		;
	public static final String PRM_LBL_LEAVE_EARLY_HOUR			= "lblLeaveEarlyHour"		;
	public static final String PRM_LBL_LEAVE_EARLY_MIN			= "lblLeaveEarlyMin"		;
	public static final String PRM_LBL_LEAVE_EARLY_CERTIFICATE 	= "lblLeaveEarlyCertificate";
	public static final String PRM_LBL_LEAVE_EARLY_COMMENT 		= "lblLeaveEarlyComment"	;

	public static final String PRM_LBL_OVER_HOUR 				= "lblOverHour"				;
	public static final String PRM_LBL_OVER_MIN 				= "lblOverMin"				;
	public static final String PRM_LBL_WORK_ON_HOLIDAY_HOUR 	= "lblWorkOnHolidayHour"	;
	public static final String PRM_LBL_WORK_ON_HOLIDAY_MIN 	= "lblWorkOnHolidayMin"		;
	public static final String PRM_LBL_LATE_NIGHT_HOUR 		= "lbllateNightHour"		;
	public static final String PRM_LBL_LATE_NIGHT_MIN 		= "lbllateNightMin"			;

	public static final String PRM_LBL_SYOKUJI 	= "lblSyokuji"	;
	public static final String PRM_LBL_CYOKU1 	= "lblCyoku1"	;	
	public static final String PRM_LBL_CYOKU2 	= "lblCyoku2"	;
	public static final String PRM_LBL_CYOKU3 	= "lblCyoku3"	;
	public static final String PRM_LBL_HOKA1		= "lblHoka1"	;
	public static final String PRM_LBL_HOKA2		= "lblHoka2"	;
	public static final String PRM_LBL_HOKA3	 	= "lblHoka3"	;
	public static final String PRM_LBL_HOKA4		= "lblHoka4"	;
	public static final String PRM_LBL_HOKA5		= "lblHoka5"	;

	public static final String PRM_LBL_APPROVAL_REASON 		= "lblApprovalReason"	;
	public static final String PRM_TXT_APPROVAL_COMMENT 		= "txtApprovalComment"	;

	public static final String PRM_HID_APPROVAL_LAYER 		= "hidApprovalLayer"	;

	// tB[h
	private String hidKCode;
	private String hidDate;

	private String lblKCode;
	private String lblKName;
	private String lblSectionName;

	private String lblYear;
	private String lblMonth;
	private String lblDay;

	private String lblStartHour;
	private String lblStartMin;
	private String lblWorkType;
	private String lblStartHalfHoliday;
	private String lblWorkOnHoliday;

	private String lblLateHour;
	private String lblLateMin;
	private String lblLateReason;
	private String lblLateCertificate;
	private String lblLateComment;

	private String lblQuitHour;
	private String lblQuitMin;
	private String lblQuitHalfHoliday;
	private String lblWorkHour;
	private String lblWorkMin;
	private String lblBreakHour;
	private String lblBreakMin;
	private String lblActualHour;
	private String lblActualMin;

	private String lblLeaveEarlyReason;
	private String lblLeaveEarlyHour;
	private String lblLeaveEarlyMin;
	private String lblLeaveEarlyCertificate;
	private String lblLeaveEarlyComment;

	private String lblOverHour;
	private String lblOverMin;
	private String lblWorkOnHolidayHour;
	private String lblWorkOnHolidayMin;
	private String lbllateNightHour;
	private String lbllateNightMin;

	private String lblSyokuji;
	private String lblCyoku1;
	private String lblCyoku2;
	private String lblCyoku3;
	private String lblHoka1;
	private String lblHoka2;
	private String lblHoka3;
	private String lblHoka4;
	private String lblHoka5;

	private String lblApprovalLayer;
	private String lblApprovalReason;
	private String txtApprovalComment;

	private String hidApprovalLayer;

	// ҏW[h(0F\A1FF)
	private int approval;

	// 蓖
	public String[][] aryAllowance;

	// v_EXg
	public String[][] aryPltWorkType;
	public String[][] aryPltStartHalfHoliday;
	public String[][] aryPltQuitHalfHoliday;
	public String[][] aryPltWorkOnHoliday;
	public String[][] aryPltLateReason;
	public String[][] aryPltLateCertificate;
	public String[][] aryPltLeaveEarlyReason;
	public String[][] aryPltLeaveEarlyCertificate;
	public String[][] aryPltApprovalReason;

	// tB[hyѐ
	public static final String NAM_START_TIME				= CommonConst.NAM_START_TIME + CommonConst.NAM_TIME;
	public static final String NAM_WORKING_TYPE			= CommonConst.NAM_WORKING_TYPE;
	public static final String NAM_START_HALF_HOLIDAY		= CommonConst.NAM_START_TIME + CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_WORK_ON_HOLIDAY		= CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TYPE;

	public static final String NAM_LATE_TIME				= CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LATE_REASON			= CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;
	public static final String NAM_LATE_CERTIFICATE		= CommonConst.NAM_CERTIFICATE;
	public static final String NAM_LATE_COMMENT 			= CommonConst.NAM_COMMENT;

	public static final String NAM_QUIT_TIME				= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME;
	public static final String NAM_QUIT_HALF_HOLIDAY		= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_WORKING_TIME			= CommonConst.NAM_WORKING 				+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_INTERVAL_TIME			= CommonConst.NAM_INTERVAL_TIME 		+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_ACTUAL_WORK_TIME		= CommonConst.NAM_ACTUAL_WORK_TIME 		+ CommonConst.NAM_COMMON_TIME;

	public static final String NAM_LEAVE_EARLY_REASON			= CommonConst.NAM_LEAVE_EARLY 		+ CommonConst.NAM_REASON;
	public static final String NAM_LEAVE_EARLY_TIME			= CommonConst.NAM_LEAVE_EARLY 		+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LEAVE_EARLY_CERTIFICATE	= CommonConst.NAM_CERTIFICATE;
	public static final String NAM_LEAVE_EARLY_COMMENT 		= CommonConst.NAM_COMMENT;

	public static final String NAM_OVER_TIME				= CommonConst.NAM_OVERTIME 			+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_WORK_ON_HOLIDAY_TIME 	= CommonConst.NAM_WORK_ON_HOLIDAY 	+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LATE_NIGHT 			= CommonConst.NAM_LATE_NIGHT 		+ CommonConst.NAM_COMMON_TIME;

	public static final String NAM_ALLOWANCE 			= CommonConst.NAM_ALLOWANCE;

	public static final String NAM_LAYER 				= CommonConst.NAM_APPROVAL_STATE;
	public static final String NAM_APPROVAL_COMMENT 	= CommonConst.NAM_APPROVED + CommonConst.NAM_COMMENT;

	public static final int	LEN_COMMENT		= 50;

	/**
	 * RXgN^
	 */
	public ApprovalCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		approval = MODE_VIEW;
		aryAllowance = new String[0][0];
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		hidKCode			= request.getParameter(PRM_HID_K_CODE);
		hidDate				= request.getParameter(PRM_HID_DATE);
		txtApprovalComment 	= request.getParameter(PRM_TXT_APPROVAL_COMMENT);
		hidApprovalLayer 	= request.getParameter(PRM_HID_APPROVAL_LAYER);
	}

	/**
	 * tB[hݒ
	 * @throws MospException 
	 */
	public void setDefaultValues() {
		lblStartHour 		= "0";
		lblStartMin			= "0";
		lblWorkType  		= "";
		lblStartHalfHoliday = "";
		lblWorkOnHoliday  	= "";

		lblLateHour 		= "0";
		lblLateMin 			= "0";
		lblLateReason 		= "";
		lblLateCertificate 	= "";
		lblLateComment 		= "";

		lblQuitHour 		= "0";
		lblQuitMin			= "0";
		lblQuitHalfHoliday	= "";
		lblWorkHour  		= "0";
		lblWorkMin  		= "0";
		lblBreakHour 		= "0";
		lblBreakMin 		= "0";

		lblLeaveEarlyReason 		= "";
		lblLeaveEarlyHour 			= "0";
		lblLeaveEarlyMin 			= "0";
		lblLeaveEarlyCertificate 	= "";
		lblLeaveEarlyComment 		= "";

		lblOverHour 			= "0";
		lblOverMin 				= "0";
		lblWorkOnHolidayHour 	= "0";
		lblWorkOnHolidayMin 	= "0";
		lbllateNightHour		= "0";
		lbllateNightMin			= "0";

		lblSyokuji	= "";
		lblCyoku1 	= "";
		lblCyoku2 	= "";
		lblCyoku3 	= "";
		lblHoka1 	= "";
		lblHoka2 	= "";
		lblHoka3 	= "";
		lblHoka4 	= "";
		lblHoka5 	= "";

		lblActualHour	= "0";
		lblActualMin	= "0";

		lblApprovalReason 	= "";
		txtApprovalComment 	= "";

		hidDate	= "";
	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MSyukkinboDto dto) {
		lblStartHour 		= util.convStringTimeToStringHour(dto.getSyJikoku());
		lblStartMin			= util.convStringTimeToStringMinutes(dto.getSyJikoku());
		lblWorkType  		= getCodeName(dto.getKinmu(),aryPltWorkType);
		lblStartHalfHoliday = getCodeName(dto.getSHankyuKb(),aryPltStartHalfHoliday);
		lblWorkOnHoliday  	= getCodeName(dto.getKyusyuKb(),aryPltWorkOnHoliday);

		lblLateHour 		= String.valueOf(util.convIntegerTimeToStringHour(dto.getTiJikan()));
		lblLateMin 			= String.valueOf(util.convIntegerTimeToStringMinutes(dto.getTiJikan()));
		lblLateReason 		= getCodeName(dto.getTiRiyuu(), aryPltLateReason);
		lblLateCertificate 	= getCodeName(dto.getTiSyoumei(),aryPltLateCertificate);
		lblLateComment 		= dto.getTiComent();

		lblQuitHour 		= util.convStringTimeToStringHour(dto.getTaJikoku());
		lblQuitMin			= util.convStringTimeToStringMinutes(dto.getTaJikoku());
		lblQuitHalfHoliday	= getCodeName(dto.getTHankyuKb(),aryPltQuitHalfHoliday);
		lblWorkHour  		= util.convIntegerTimeToStringHour(dto.getKinmuJi());
		lblWorkMin  		= util.convIntegerTimeToStringMinutes(dto.getKinmuJi());
		lblBreakHour 		= util.convIntegerTimeToStringHour(dto.getKyukeiJi());
		lblBreakMin 		= util.convIntegerTimeToStringMinutes(dto.getKyukeiJi());

		lblLeaveEarlyReason 		= getCodeName(dto.getSoRiyuu(), aryPltLeaveEarlyReason);
		lblLeaveEarlyHour 			= util.convIntegerTimeToStringHour(dto.getSoJikan());
		lblLeaveEarlyMin 			= util.convIntegerTimeToStringMinutes(dto.getSoJikan());
		lblLeaveEarlyCertificate 	= getCodeName(dto.getSoSyoumei(),aryPltLeaveEarlyCertificate);
		lblLeaveEarlyComment 		= dto.getSoComent();

		lblOverHour 			= util.convIntegerTimeToStringHour(dto.getZaJikan());
		lblOverMin 				= util.convIntegerTimeToStringMinutes(dto.getZaJikan());
		lblWorkOnHolidayHour 	= util.convIntegerTimeToStringHour(dto.getKsJikan());
		lblWorkOnHolidayMin 	= util.convIntegerTimeToStringMinutes(dto.getKsJikan());
		lbllateNightHour		= util.convIntegerTimeToStringHour(dto.getSnJikan());
		lbllateNightMin			= util.convIntegerTimeToStringMinutes(dto.getSnJikan());

		lblSyokuji	= String.valueOf(dto.getSyokuji());
		lblCyoku1 	= String.valueOf(dto.getCyoku1());
		lblCyoku2 	= String.valueOf(dto.getCyoku2());
		lblCyoku3 	= String.valueOf(dto.getCyoku3());
		lblHoka1 	= String.valueOf(dto.getHoka1());
		lblHoka2 	= String.valueOf(dto.getHoka2());
		lblHoka3 	= String.valueOf(dto.getHoka3());
		lblHoka4 	= String.valueOf(dto.getHoka4());
		lblHoka5 	= String.valueOf(dto.getHoka5());

		// Ԃ̃Zbg
		//  = Ζ - xeԁicƋxeԊ܂ށj
		int actual = 0;
		if (dto.getKinmuJi() != 0) {
			actual = dto.getKinmuJi() - dto.getKyukeiJi();
		}
		lblActualHour	= util.convIntegerTimeToStringHour(actual);
		lblActualMin	= util.convIntegerTimeToStringMinutes(actual);

		lblApprovalReason 	= getCodeName(dto.getSnRiyuu(),aryPltApprovalReason);
		txtApprovalComment 	= dto.getSnComent();

		hidDate	= MospUtility.getDateString(util.getDate(dto.getNen(), dto.getTuki(), dto.getHi()), CommonConst.FORMAT_DATE);

		lblYear 	= String.valueOf(dto.getNen());
		lblMonth 	= String.valueOf(dto.getTuki());
		lblDay 		= String.valueOf(dto.getHi());
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtApprovalComment, NAM_APPROVAL_COMMENT, PRM_TXT_APPROVAL_COMMENT);
		// mF	
		checkLength(txtApprovalComment, LEN_COMMENT, NAM_APPROVAL_COMMENT, PRM_TXT_APPROVAL_COMMENT);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var APPROVAL = ");
		sb.append(approval);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String[][] getAryAllowance() { return aryAllowance.clone(); }

	public String getHidKCode		() { return hidKCode	; }
	public String getHidDate		() { return hidDate		; }

	public String getEscLblKCode		() { return escapeHTML(lblKCode			); }
	public String getEscLblKName		() { return escapeHTML(lblKName			); }
	public String getEscLblSectionName	() { return escapeHTML(lblSectionName	); }

	public String getEscLblStartHour			() { return escapeHTML(lblStartHour			); }
	public String getEscLblStartMin				() { return escapeHTML(lblStartMin			); }
	public String getEscLblWorkType				() { return escapeHTML(lblWorkType			); }
	public String getEscLblStartHalfHoliday		() { return escapeHTML(lblStartHalfHoliday	); }
	public String getEscLblWorkOnHoliday		() { return escapeHTML(lblWorkOnHoliday		); }
	public String getEscLblLateHour				() { return escapeHTML(lblLateHour			); }
	public String getEscLblLateMin				() { return escapeHTML(lblLateMin			); }
	public String getEscLblLateReason			() { return escapeHTML(lblLateReason		); }
	public String getEscLblLateCertificate		() { return escapeHTML(lblLateCertificate	); }
	public String getEscLblLateComment			() { return escapeHTML(lblLateComment		); }

	public String getEscLblQuitHour			() { return escapeHTML(lblQuitHour			); }
	public String getEscLblQuitMin			() { return escapeHTML(lblQuitMin			); }
	public String getEscLblQuitHalfHoliday	() { return escapeHTML(lblQuitHalfHoliday	); }
	public String getEscLblWorkHour			() { return escapeHTML(lblWorkHour			); }
	public String getEscLblWorkMin			() { return escapeHTML(lblWorkMin			); }
	public String getEscLblBreakHour		() { return escapeHTML(lblBreakHour			); }
	public String getEscLblBreakMin			() { return escapeHTML(lblBreakMin			); }

	public String getEscLblLeaveEarlyReason			() { return escapeHTML(lblLeaveEarlyReason		); }
	public String getEscLblLeaveEarlyHour			() { return escapeHTML(lblLeaveEarlyHour		); }
	public String getEscLblLeaveEarlyMin			() { return escapeHTML(lblLeaveEarlyMin			); }
	public String getEscLblLeaveEarlyCertificate	() { return escapeHTML(lblLeaveEarlyCertificate	); }
	public String getEscLblLeaveEarlyComment		() { return escapeHTML(lblLeaveEarlyComment		); }

	public String getEscLblOverHour				() { return escapeHTML(lblOverHour			); }
	public String getEscLblOverMin				() { return escapeHTML(lblOverMin			); }
	public String getEscLblWorkOnHolidayHour	() { return escapeHTML(lblWorkOnHolidayHour	); }
	public String getEscLblWorkOnHolidayMin		() { return escapeHTML(lblWorkOnHolidayMin	); }
	public String getEscLbllateNightHour		() { return escapeHTML(lbllateNightHour		); }
	public String getEscLbllateNightMin			() { return escapeHTML(lbllateNightMin		); }

	public String getEscLblSyokuji	() { return escapeHTML(lblSyokuji	); }
	public String getEscLblCyoku1	() { return escapeHTML(lblCyoku1	); }
	public String getEscLblCyoku2	() { return escapeHTML(lblCyoku2	); }
	public String getEscLblCyoku3	() { return escapeHTML(lblCyoku3	); }
	public String getEscLblHoka1	() { return escapeHTML(lblHoka1		); }
	public String getEscLblHoka2	() { return escapeHTML(lblHoka2		); }
	public String getEscLblHoka3	() { return escapeHTML(lblHoka3		); }
	public String getEscLblHoka4	() { return escapeHTML(lblHoka4		); }
	public String getEscLblHoka5	() { return escapeHTML(lblHoka5		); }

	public String getEscLblActualHour	() { return escapeHTML(lblActualHour	); }
	public String getEscLblActualMin	() { return escapeHTML(lblActualMin		); }

	public String getEscLblApprovalLayer	() { return escapeHTML(lblApprovalLayer		); }
	public String getEscLblApprovalReason	() { return escapeHTML(lblApprovalReason	); }
	public String getEscTxtApprovalComment	() { return escapeHTML(txtApprovalComment	); }

	public String getTxtApprovalComment		() { return txtApprovalComment	; }

	public void setHidKCode	(String hidKCode	) { this.hidKCode	= hidKCode	; }
	public void setHidDate		(String hidDate		) { this.hidDate 	= hidDate	; }

	public void setLblKCode		(String lblKCode		) { this.lblKCode		= lblKCode		; }
	public void setLblKName		(String lblKName		) { this.lblKName		= lblKName		; }
	public void setLblSectionName	(String lblSectionName	) { this.lblSectionName	= lblSectionName; }

	public void setLblApprovalLayer(String lblApprovalLayer) { this.lblApprovalLayer 	= lblApprovalLayer	; }

	public String getHidApprovalLayer	() { return hidApprovalLayer	; }
	public void setHidApprovalLayer	(String hidApprovalLayer) { this.hidApprovalLayer 	= hidApprovalLayer	; }

	public String getEscLblDay		() { return escapeHTML(lblDay		); }
	public String getEscLblMonth	() { return escapeHTML(lblMonth		); }
	public String getEscLblYear		() { return escapeHTML(lblYear		); }

	public void setLblDay		(String lblDay	) { this.lblDay 	= lblDay	; }
	public void setLblMonth	(String lblMonth) { this.lblMonth 	= lblMonth	; }
	public void setLblYear		(String lblYear	) { this.lblYear 	= lblYear	; }

	public void setApproval(int approval) { this.approval = approval; }
	public int getApproval() { return approval; }

}
